//----------------------------------------------------------------------------------------
//  svO(G-ROBOTSp)
//
//      RPU-10AGDL V2.00
//      EWCڋ@̏ꍇHOKOU_GYRO1ɁA񓋍ڂ̏ꍇ0ɁAItZbglMEDIAN_GXAMEDIAN_GYAKRG-4gpAWCPID
//          ENāAMODE{^ŕsX^oCAX^oCA{^3ŕsJn
//          EXeBbNőO㍶EAEXeBbNōE
//          EsxAsp[^͓KX
//
//      AUTHORED BY Micchy @ Dream Drive !!
//----------------------------------------------------------------------------------------
#include    <avr/pgmspace.h>
#include    <avr/io.h>
#include    <avr/interrupt.h>
#include    <avr/eeprom.h>
#include    <stdio.h>
#include    <math.h>
#include    <avr/boot.h>
#include    <avr/wdt.h>

#include    <sv.h>
#include    <rs.h>

#include    <../ATmega128/rs0_printf_P.c>   //  URART0ptH[}bgiROMpj

//---------define----------------------------------------------------------------------------------------

#define SQUARE(x) ((x) * (x))
#define RADIANS(deg) ((deg) * M_PI / 180.0)
#define DEGREES(rad) ((rad) * 180.0 / M_PI)

//  萔`
#define SERVO_MAX 20           //  ΏۃT[{
#define a 48
#define b 59
#define c 5
#define d 28
#define e 2.8

// sp`
#define takasa 104 //104 - > 110
#define taijuy 25  //25 -> 16 ->17
#define ashiage1 10 //10
#define ashiage2 20 //20
#define kaikyaku 10       //  10 -> 20
#define yaw_space 45
#define ASI_URA_DEG 0.2
#define walk_bunkatsu 10   //4   (1,2:/3,4 OK/5,LUH/6`) / 3ŁA

// WC萔 
#define MEDIAN_GX 275
#define MEDIAN_GY 276
#define HOKOU_GYRO 0  //1:ON / 0:OFF

double gx_p_gain=1.0; //PQC
double gx_i_gain=0.001; //IQCiƖ\܂j ----> 0.001 - > 2
double gx_d_gain=0.5; //DQC
double gx_target_value = MEDIAN_GX ; //ڕW̏o͒liڕWlj -----------------WC̒l
double gx_control_value = 0.0; //ʁi[^Ȃǂւ̓͗ʁj--------------T[{ւ̕t

double gy_p_gain=1.0; //PQC
double gy_i_gain=0.001; //IQCiƖ\܂j
double gy_d_gain=0.5; //DQC
double gy_target_value = MEDIAN_GY; //ڕW̏o͒liڕWlj -----------------WC̒l
double gy_control_value = 0.0; //ʁi[^Ȃǂւ̓͗ʁj--------------T[{ւ̕t

//---------------------------------------

//(uU[p̒`)
#define OTO_1C  439

//---------\̐錾------------------------------------------------------------------------------------

typedef struct {  //r̍\
    float x;
    float y;
    float z;
    float yo;
    float pi;
    float ro;
} WLEG;

typedef struct {  //̂̍\
    WLEG left;
    WLEG right;
} WPOSE;

//---------O[oϐ--------------------------------------------------------------------------------

unsigned char   GRaucTBuff[256];            // RS485ʐMpobt@
SRV_PACKET GOAL_svPacket[SERVO_MAX+1];      // T[{̖ڕWl(G-ROBOTSID1n܂Ȃ̂+1
WPOSE past_poze;                            // ԍŌ̃|[YL^邽߂̕ϐI

//-------------------------------------------------------------------------------------------------------

//
//  T[{Ǘ
//      vꂽԁApxɂApxwT[{ɍs܂B
//
void    sendAngles( short go_time ){
    unsigned char   ucID;
    SRV_PACKET      asvrPacket[SERVO_MAX];
    
    for( ucID = 0; ucID < SERVO_MAX; ucID++ ){
        asvrPacket[ucID].id = ucID + 1;
        asvrPacket[ucID].angle =GOAL_svPacket[ucID+1].angle;
        asvrPacket[ucID].time = go_time;
    }
    SV_TxPacket( GRaucTBuff, 0, 0x00, 0x1E, 5, 20, (unsigned char*)asvrPacket, 100 );
}

int leg_xyz( WLEG goal ,int R0L1){

    float x,y,z,yo,r,si,dax,day,daL,he_s,he_das,h,arufa,beta,d_arufa,d_beta,dd_beta,sig,ipu,aaa,bbb,ccc,ddd,eee,fff,ggg,hhh,iii;
    float temp,temp2;

    x = goal.x + d;
    y = goal.y - e;
    z = goal.z;
    yo = goal.yo;

    r = sqrt( (x * x ) + ( y * y ) );
    if (x==0 && y==0)si = 0;
    else si = atan2(y,x);
    temp = si - RADIANS(yo);
    dax = r * cos(temp) - d;
    day = r * sin(temp) + e;

    temp = sqrt( SQUARE(z) + SQUARE(day) ) - c;
    daL =sqrt( SQUARE(dax) + SQUARE(temp) );

    he_s = (a + b + daL )/2;
    he_das =sqrt(he_s *(he_s - a)*(he_s-b)*(he_s-daL));
    h = 2 * he_das / daL;
    
    arufa = asin( h / a );
    beta = acos( h / a );
    d_arufa = asin( h / b );
    d_beta = acos( h / b );
    dd_beta = beta + d_beta;
    sig = asin(dax / daL);
    ipu = atan(day/z);
    
    aaa = DEGREES(arufa + sig);
    bbb = DEGREES(d_arufa - sig);
    ccc = 180-DEGREES(dd_beta);
    ddd = DEGREES(ipu);
    eee = yo;
    
    temp = cos(RADIANS(goal.yo));
    temp2 = sin(RADIANS(goal.yo));
    fff = goal.pi * temp;
    ggg = goal.pi * temp2;
    hhh = -goal.ro * temp2;
    iii = goal.ro * temp;
     
    if(R0L1 == 0){
       GOAL_svPacket[ 9].angle = (short)(10 * (-eee));
       GOAL_svPacket[11].angle = (short)(10 * (ddd));
       GOAL_svPacket[10].angle = (short)(10 * (aaa));
       GOAL_svPacket[12].angle = (short)(10 * (-ccc));
       GOAL_svPacket[13].angle = (short)(10 * (-bbb + hhh - fff));
       GOAL_svPacket[14].angle = (short)(10 * (ddd - iii + ggg));
       return 0;
    }
    else if(R0L1 == 1) {
       GOAL_svPacket[15].angle = (short)(10 * (eee));
       GOAL_svPacket[17].angle = (short)(10 * (-ddd));
       GOAL_svPacket[16].angle = (short)(10 * (-aaa));
       GOAL_svPacket[18].angle = (short)(10 * (ccc));
       GOAL_svPacket[19].angle = (short)(10 * (bbb - hhh + fff));
       GOAL_svPacket[20].angle = (short)(10 * (-ddd + iii - ggg));
       return 0;
    }
    
    return 1;
}

int move_xyz( WPOSE goal_poze , int div_num , int gyro , short go_time ){

    WPOSE now_poze;	//݂̊px
    int count = 0;

    unsigned short  usGyroX, usGyroY;       //  WCϐ
    int gx,gy;
    
    //WCPID֘Aϐ
    double gx_current_value;            //݂̏o͒l
    static double gx_last_value = 0.0;  //Ȍo͒livۑ̂staticj
    double gx_error,gx_d_error;         //΍A΍̔ω
    static double gx_i_error=0.0;       //΍̑aivۑ̂staticj

    double gy_current_value;            //݂̏o͒l
    static double gy_last_value = 0.0;  //Ȍo͒livۑ̂staticj
    double gy_error,gy_d_error;         //΍A΍̔ω
    static double gy_i_error=0.0;       //΍̑aivۑ̂staticj
    
    while (count < div_num){
        count = count + 1;

        //ans = x + (y - x) * count / div_num
        now_poze.left.x   = past_poze.left.x   + ( goal_poze.left.x   - past_poze.left.x   ) * count / div_num;
        now_poze.left.y   = past_poze.left.y   + ( goal_poze.left.y   - past_poze.left.y   ) * count / div_num;
        now_poze.left.z   = past_poze.left.z   + ( goal_poze.left.z   - past_poze.left.z   ) * count / div_num;
        now_poze.left.yo  = past_poze.left.yo  + ( goal_poze.left.yo  - past_poze.left.yo  ) * count / div_num;
        now_poze.left.pi  = past_poze.left.pi  + ( goal_poze.left.pi  - past_poze.left.pi  ) * count / div_num;
        now_poze.left.ro  = past_poze.left.ro  + ( goal_poze.left.ro  - past_poze.left.ro  ) * count / div_num;

        now_poze.right.x  = past_poze.right.x  + ( goal_poze.right.x  - past_poze.right.x  ) * count / div_num;
        now_poze.right.y  = past_poze.right.y  + ( goal_poze.right.y  - past_poze.right.y  ) * count / div_num;
        now_poze.right.z  = past_poze.right.z  + ( goal_poze.right.z  - past_poze.right.z  ) * count / div_num;
        now_poze.right.yo = past_poze.right.yo + ( goal_poze.right.yo - past_poze.right.yo ) * count / div_num;
        now_poze.right.pi = past_poze.right.pi + ( goal_poze.right.pi - past_poze.right.pi ) * count / div_num;
        now_poze.right.ro = past_poze.right.ro + ( goal_poze.right.ro - past_poze.right.ro ) * count / div_num;

        if(gyro){ // gyro1ł΃WC␳g0Ȃ␳gȂ

            //  WCZTl̎荞
            RPU_GetGyro( &usGyroX, &usGyroY );
            
            gx_current_value = (double) usGyroX;           //WC̒lcurrent_valueɃLXg
            gy_current_value = (double) usGyroY;           //WC̒lcurrent_valueɃLXg
            
            gx_error = gx_target_value - gx_current_value; //΍̌vZ
            gx_d_error = gx_current_value - gx_last_value; //΍ωʂ̌vZ

            gy_error = gy_target_value - gy_current_value; //΍̌vZ
            gy_d_error = gy_current_value - gy_last_value; //΍ωʂ̌vZ
            
            gx_control_value = gx_p_gain * gx_error + gx_i_gain * gx_i_error + gx_d_gain * gx_d_error;  //ʂ̌vZ(PID)
            gy_control_value = gy_p_gain * gy_error + gy_i_gain * gy_i_error + gy_d_gain * gy_d_error;  //ʂ̌vZ(PID)
            
            gx = (int)gx_control_value * 0.2;
            gy = (int)gy_control_value * 0.2;
            
            //sb`ƃ[␳(WC)
            now_poze.left.pi = now_poze.left.pi + gx;     
            now_poze.right.pi = now_poze.right.pi + gx;   
            now_poze.left.ro = now_poze.left.ro - gy;     
            now_poze.right.ro = now_poze.right.ro + gy;   

            //Z␳(WC)
            now_poze.left.z  = (int)(now_poze.left.z  + ((float)now_poze.left.x  * tan( M_PI * ( (float)-gx / 180)) + (((float)now_poze.left.y  + (yaw_space / 2)) * tan( M_PI * ( (float)gy / 180)))));
            now_poze.right.z = (int)(now_poze.right.z + ((float)now_poze.right.x * tan( M_PI * ( (float)-gx / 180)) + (((float)now_poze.right.y + (yaw_space / 2)) * tan( M_PI * ( (float)gy / 180)))));
            
            gx_last_value = gx_current_value; //Ȍo͒lXV
            gx_i_error += gx_error; //΍̑aXV
  
            gy_last_value = gy_current_value; //Ȍo͒lXV
            gy_i_error += gy_error; //΍̑aXV
        }

        //t^wvZOpPbgMI
        leg_xyz(now_poze.right,0); //EvZ
        leg_xyz(now_poze.left ,1); //vZ
        sendAngles(go_time);        //pxM
    }

    past_poze = goal_poze;    //ߋlۑ

    return 0;
}

//ĂяoƁÃ݂|[YEH[N|WVɂڍs(1b)
int test_poze(void){
    
    //past_pozẽZbg
    past_poze.left.x   =30;
    past_poze.left.y   =20;
    past_poze.left.z   =100;
    past_poze.left.yo  =10;
    past_poze.left.pi  =0;
    past_poze.left.ro  =0;
    past_poze.right.x  =-30;
    past_poze.right.y  =20;
    past_poze.right.z  =100;
    past_poze.right.yo =10;
    past_poze.right.pi =0;
    past_poze.right.ro =0;
    
    GOAL_svPacket[5].angle = -1200;
    GOAL_svPacket[8].angle =  1200;
    
    while(1){
    
          //݂̃|[Yߋ|[YɃZbg
          move_xyz( past_poze , 1 , HOKOU_GYRO , 0);	//(walk_bunkatsu),WCȂ(HOKOU_GYRO),s(0.0ms)  [uI
    }
    return 0;
}

//ĂяoƁÃ݂|[YEH[N|WVɂڍs(1b)
int reset_walk(void){
    
    //past_pozẽZbg
    past_poze.left.x   =0;
    past_poze.left.y   =0;
    past_poze.left.z   =takasa;
    past_poze.left.yo  =0;
    past_poze.left.pi  =0;
    past_poze.left.ro  =0;
    past_poze.right.x  =0;
    past_poze.right.y  =0;
    past_poze.right.z  =takasa;
    past_poze.right.yo =0;
    past_poze.right.pi =0;
    past_poze.right.ro =0;
    
    GOAL_svPacket[5].angle = -1200;
    GOAL_svPacket[8].angle =  1200;


    GOAL_svPacket[1].angle = 0;
        
    //݂̃|[Yߋ|[YɃZbg
    move_xyz( past_poze , 1 , 0 , 30);	//1,WCȂ(0),s(3.0s)  [uI
    
    RPU_ResetTimerCounter();    //3b҂
    while( RPU_GetTimerCounter10() < 300 );
    
    return 0;
}

int hokou(void){

    int i = 0;
    float hohaba,keri,senkai_yo,side_r,side_l,side,ghosei;
    char acPad[8];                       //  Rg[pbhf[^i[ϐ
    short sResult;                        //  Rg[pbhM
    WPOSE walk_poze;
    
    //C[v
    while( 1 ){
        if (i == 6) i = 0;
        
        sResult = RPU_GetController( acPad );

        //sp^[
        
        hohaba = (128-(int)acPad[6])/8;         //
        keri = hohaba / 4;                      //Rグ      4-8
        senkai_yo = -(128-(int)acPad[3])/20;    //px  ------------------------------------------- 14 -> 24 -> 20
        
        side = (128-(int)acPad[5]) / 8;        //TChXebvړʌ  -------------------------------  16 -> 4
        if (side > 0){
            side_l = side;
            side_r = 0;
        }
        else{
            side_l = 0;
            side_r = -side;
        }
        
        ghosei = -(hohaba / 8);                 //dS␳(x)
        
        //T[{(ߋ@\)
        GOAL_svPacket[2].angle = (short)(senkai_yo * 40);
        
        if(i==0){       //_1
            //1ԃ|[Y
            walk_poze.left.x   = ghosei;
            walk_poze.left.y   = (kaikyaku / 2) - taijuy + (side_l / 4) + (side_r / 4);
            walk_poze.left.z   = takasa;
            if(senkai_yo<0) walk_poze.left.yo = 0;
            else walk_poze.left.yo  = senkai_yo;
            walk_poze.left.pi  = 0;
            walk_poze.left.ro  = 0;
            //------------------------------------------
            walk_poze.right.x  = ghosei;
            walk_poze.right.y  = (kaikyaku / 2) + taijuy + (side_l / 4) + (side_r / 4);
            walk_poze.right.z  = takasa - ashiage2;
            walk_poze.right.yo = walk_poze.left.yo;
            walk_poze.right.pi = 0;
            walk_poze.right.ro = 0;
        }
        else if (i==1){
            //2ԃ|[Y
            walk_poze.left.x   = ghosei - hohaba;
            walk_poze.left.y   = (kaikyaku / 2) - (taijuy / 2) + (side_r / 2);
            walk_poze.left.z   = takasa;
            if(senkai_yo<0) walk_poze.left.yo = 0;
            else walk_poze.left.yo  = senkai_yo;
            walk_poze.left.pi  = 0;
            walk_poze.left.ro  = 0;
            //------------------------------------------
            walk_poze.right.x  = ghosei + hohaba + keri;
            walk_poze.right.y  = (kaikyaku / 2) + (taijuy / 2) + (side_r / 2);
            walk_poze.right.z  = takasa - ashiage1;
            walk_poze.right.yo = walk_poze.left.yo;
            walk_poze.right.pi = ASI_URA_DEG * hohaba;
            walk_poze.right.ro = 0;
        }
        else if (i==2){
            //3ԃ|[Y
            walk_poze.left.x   =  ghosei - hohaba -keri;
            walk_poze.left.y   = (kaikyaku / 2) + (taijuy / 2) + (side_r / 2);
            walk_poze.left.z   = takasa - ashiage1;
            if(senkai_yo<0) walk_poze.left.yo = 0;
            else walk_poze.left.yo  = senkai_yo;
            walk_poze.left.pi  = -ASI_URA_DEG * hohaba;
            walk_poze.left.ro  = 0;
            //------------------------------------------
            walk_poze.right.x  = ghosei + hohaba;
            walk_poze.right.y  = (kaikyaku / 2) - (taijuy / 2) + (side_r / 2);
            walk_poze.right.z  = takasa;
            walk_poze.right.yo = walk_poze.left.yo;
            walk_poze.right.pi = 0;
            walk_poze.right.ro = 0;
        }
        else if (i==3){       //_2
            //4ԃ|[Y
            walk_poze.left.x   = ghosei;
            walk_poze.left.y   = (kaikyaku / 2) + taijuy + (side_l / 4) + (side_r / 4);
            walk_poze.left.z   = takasa - ashiage2;
            if(senkai_yo>0) walk_poze.left.yo = 0;
            else walk_poze.left.yo  = -senkai_yo;
            walk_poze.left.pi  = 0;
            walk_poze.left.ro  = 0;
            //------------------------------------------
            walk_poze.right.x  = ghosei;
            walk_poze.right.y  =  (kaikyaku / 2) - taijuy + (side_l / 4) + (side_r / 4);
            walk_poze.right.z  = takasa;
            walk_poze.right.yo = walk_poze.left.yo;
            walk_poze.right.pi =0;
            walk_poze.right.ro =0;
        }
        else if (i==4){
            //5ԃ|[Y
            walk_poze.left.x   = ghosei + hohaba + keri;
            walk_poze.left.y   = (kaikyaku / 2) + (taijuy / 2) + (side_l / 2);
            walk_poze.left.z   = takasa - ashiage1;
            if(senkai_yo>0) walk_poze.left.yo = 0;
            else walk_poze.left.yo  = -senkai_yo;
            walk_poze.left.pi  = ASI_URA_DEG * hohaba;
            walk_poze.left.ro  = 0;
            //------------------------------------------
            walk_poze.right.x  = ghosei - hohaba;
            walk_poze.right.y  = (kaikyaku / 2) - (taijuy / 2) + (side_l / 2);
            walk_poze.right.z  = takasa;
            walk_poze.right.yo = walk_poze.left.yo;
            walk_poze.right.pi = 0;
            walk_poze.right.ro = 0;
        }
        else if (i==5){
            //6ԃ|[Y
            walk_poze.left.x   = ghosei + hohaba;
            walk_poze.left.y   = (kaikyaku / 2) - (taijuy / 2) + (side_l / 2);
            walk_poze.left.z   = takasa;
            if(senkai_yo>0) walk_poze.left.yo = 0;
            else walk_poze.left.yo  = -senkai_yo;
            walk_poze.left.pi  = 0;
            walk_poze.left.ro  = 0;
            //------------------------------------------
            walk_poze.right.x  = ghosei - hohaba - keri;
            walk_poze.right.y  = (kaikyaku / 2) + (taijuy / 2) + (side_l / 2);
            walk_poze.right.z  = takasa -ashiage1;
            walk_poze.right.yo = walk_poze.left.yo;
            walk_poze.right.pi = -ASI_URA_DEG * hohaba;
            walk_poze.right.ro = 0;
        }
        else return 1;
        
        

        move_xyz( walk_poze , walk_bunkatsu , HOKOU_GYRO , 0);	//(walk_bunkatsu),WCȂ(HOKOU_GYRO),s(0.0ms)  [uI

        i = i + 1;
    }
    return 0;
}

//ĂяoƁÃ݂|[Yz[|WV(ALL 0)ɂڍs(3b)
int reset_pose(void){
    unsigned char   ucID;                   //  T[{ID
    
    // ST[{z[|WV(0)ݒ
    for( ucID = 0; ucID < SERVO_MAX; ucID++ ){
       GOAL_svPacket[ucID+1].angle=0;
    }
    
    sendAngles(30);        //pxM
    
    RPU_ResetTimerCounter();    //3b҂
    while( RPU_GetTimerCounter10() < 300 );
    
    return 0;
}

int main( void )
{
    unsigned char   ucID;                   //  T[{ID
    char    acPad[8];                       //  Rg[pbhf[^i[ϐ
    short   sResult;                        //  Rg[pbhM
    
    RPU_InitConsole( br115200 );            //  RPU-10Cȕ
    SV_Init( br115200 );                    //  T[{䃉Cȕ
    sei();                                  //  荞ݏJn

    //  Pb҂i悭mȂǕKv炵j
    RPU_ResetTimerCounter();
    while( RPU_GetTimerCounter10() < 100 );
    
    //  T[{gNI
    for( ucID = 0; ucID < SERVO_MAX; ucID++ ){
        SV_TorqueOnOff( GRaucTBuff, ucID+1, 1 );
    }
    
    //T[{z[|WV
    reset_pose();
    
    //eXg̎̊֐
    //test_poze();
    
    //Rg[[ڑ҂
    while(1){
        sResult = RPU_GetController( acPad );
        if (acPad[7] == 0xf3) break;
        RPU_ResetTimerCounter();
        while( RPU_GetTimerCounter10() < 10 );
    }
    
    //EH[N̊{|WVɈڍs
    reset_walk();
    
    //Rg[[ڑ&sŃuU[(ҋ@)
    RPU_Buzzer( OTO_1C );
    
    //s҂(3ԃ{^ŕsJnI)
    while(1){
        sResult = RPU_GetController( acPad );
        if (acPad[2] == 0xBF) break;
        RPU_ResetTimerCounter();
        while( RPU_GetTimerCounter10() < 2 );
    }
    
    //uU[OFF
    RPU_BuzzerOff();
        
    hokou();  //sJnIin߂~܂Ȃj
    
    return 1;
}
